package main

import (
	"os"
	"os/signal"
	"syscall"
)

type worker func()

func LoopFunc(work worker)  {
	done := waitInterrupt()

	Loop:
	for {
		work()
		select {
			case <- done:
				break Loop
			default:
				continue
		}
	}
	//fmt.Println("exit")
}

func waitInterrupt()chan bool{
	sigs := make(chan os.Signal, 1)
	done := make(chan bool, 1)

	signal.Notify(sigs, syscall.SIGINT, syscall.SIGTERM)

	go func() {
		<- sigs
		//sig := <-sigs
		//fmt.Println(sig)
		done <- true
	}()

	return done
}

//func main() {
//	myFunc := func() {
//		t := []int{0,1,2,3,4}
//
//		for _, v := range t{
//			fmt.Println(v)
//			time.Sleep(1 * time.Second)
//		}
//	}
//
//	LoopFunc(myFunc)
//}